<% 

//**************************************************************************************//
//	UCGuru.com wallboard v1.42							//
//	file - default.asp								//
//	updated 2014-08-05								//
//											//
//	Updated script to work with UCCX 10					        //
// 	This script will use the wallboard user to pull general queue stats		//
//	This was built on the work of others, namely the guys on the official		//
//	Cisco forum									//
//											//
//	Updated by the guys at ucguru.com						//
//  ----------------------------------------------------------------------------------	//
//											//
//**************************************************************************************//


//  Historical notes:
//**********************************************************************************************//
//	IPCC wallboard.asp version 2.4(beta)							//
//												//
//	This ASP script is developed using the input of several individuals at the		//
// 	Cisco Netpro Forum.	You are invited to develop this script urther, make changes, 	//
//	add items, et cetera. This script is open source, no copyrights, and may never be 	//
//	used commercially. If making changes/additions or introducing new features, you 	//
//	agree that you will post back to the Cisco Netpro Forum community.			//
//  ----------------------------------------------------------------------------------		//
//   FILE:    wallboard.asp									//
//	 Build:	  20080218.002									//
//   PURPOSE: Retrieves CSQ stats from IPCC and formats for display in HTML Browsers.		//
//   AUTHORS: 	Leo Mourits		(l.mourits)						//
//				Mat Melbourne	(mmelbourne)					//
//				Joe Conger		(joe.conger)				//
//				Peso								//
//				Robby Butler							//
//				Jeremy Fielder 	(fielderj)					//
//**********************************************************************************************//

Dim objCN, objRS, strSQL, selectSQL, whereSQL, orderbySQL, strAgentStatus, strArray, NextStats, TextColor, TableColor
Dim AgentStatusBlink, CurrentDateTime, EventHappenedDateTime, StatusDateTime
Dim intStatusSeconds, intStatusMinutes, intStatusHours, intStatusDays
Dim strStatusSeconds, strStatusMinutes, strStatusHours, strStatusDays
Dim teamsToTrack
Dim prettyCSQname
Dim callsDequeued
Dim csqSpecificOrder
Dim sOffset, cTime, tDiff

%>

<!--#include file="parameters.cfg"-->

<%

//*******************************START SELECT MODULE************************************//

//**************************************************************************************//
//   Module:  	Select Stats Display													//
//   AUTHOR:  	Leo Mourits & Jeremy Fielder											//
//   PURPOSE: 	Checks parameters for enabled stats and redirects to stats based on 	//
//				where you were, and where you want to go.								//
//**************************************************************************************//

Select Case Request.QueryString("Stats")
  Case ""
    If DisplayCSQStatsTrue = 1 Then
      	Response.Redirect("default.asp?Stats=CSQ")
    ElseIf DisplayAgentsStatsTrue = 1 Then
        Response.Redirect("default.asp?Stats=Agent")
	ElseIf DisplayICDStatsTrue = 1 Then
        Response.Redirect("default.asp?Stats=ICD")
    Else
        Response.Write "Your parameters are configured to not display any statistics"
    End If
  Case "Agent"
    If DisplayICDStatsTrue = 1 Then
      NextStats = "ICD"
    ElseIf DisplayCSQStatsTrue = 1 Then
      NextStats = "CSQ"
	Else
      NextStats = "Agent"
    End If
    If DisplayAgentsStatsTrue = 1 Then
      Call PrintPageHeader_AgentStats
      Call PrintTableHeader_AgentStats
      Call DisplayAgentStatistics
      Call PrintTableFooter_Agent
    End If
  Case "CSQ"
    If DisplayAgentsStatsTrue = 1 Then
      NextStats = "Agent"
	ElseIf DisplayICDStatsTrue = 1 Then
      NextStats = "ICD"
    Else
      NextStats = "CSQ"
    End If
    If DisplayCSQStatsTrue = 1 Then
      Call PrintPageHeader_CSQStats
      Call PrintTableHeader_CSQStats
      Call DisplayCSQStatistics
      Call PrintTableFooter_CSQ
    End If
  Case "ICD"
    If DisplayCSQStatsTrue = 1 Then
      NextStats = "CSQ"
    ElseIf DisplayAgentsStatsTrue = 1 Then
      NextStats = "Agent"
	Else
	  NextStats = "ICD"
    End If
    If DisplayICDStatsTrue = 1 Then
      Call PrintPageHeader_ICDStats
      Call PrintTableHeader_ICDStats
      Call DisplayICDStatistics
      Call PrintTableFooter_ICD
    End If
  Case "AgentHeld"
  	  NextStats = "AgentHeld&PageHeld=YES"
      Call PrintPageHeader_AgentStats
      Call PrintTableHeader_AgentStats
      Call DisplayAgentStatistics
      Call PrintTableFooter_Agent
  Case "CSQHeld"
  	  NextStats = "CSQHeld&PageHeld=YES"
      Call PrintPageHeader_CSQStats
      Call PrintTableHeader_CSQStats
      Call DisplayCSQStatistics
      Call PrintTableFooter_CSQ
  Case "ICDHeld"
   	  NextStats = "ICDHeld&PageHeld=YES"
      Call PrintPageHeader_ICDStats
      Call PrintTableHeader_ICDStats
      Call DisplayICDStatistics
      Call PrintTableFooter_ICD
End Select

Response.AddHeader "Refresh", RefreshTime & "; URL=" & ServerURL & "default.asp?Stats=" & NextStats

//********************************END SELECT MODULE************************************//


Call PrintPageFooter


//*******************************START AGENT MODULE*************************************//

//**************************************************************************************//
//   Module:  	Display Agent Stats														//
//   AUTHOR:  	Leo Mourits																//
//   PURPOSE: 	Displays Agent Statistics												//
//**************************************************************************************//

Sub PrintPageHeader_AgentStats
  Response.Write "<HTML><BODY BGCOLOR='#FFFFFF'><HEAD><TITLE>" & strPageTitle & "</TITLE>"
  Response.Write "<STYLE><!--  @media screen  { blink { behavior:url(blink.htc);} } --></STYLE>"
  Response.Write "<link rel='icon'type='image/ico' href='" & ServerURL & "favicon.ico' />"
  Response.Write "<link type=text/css href=./style.css rel=stylesheet />"
  Response.Write "</HEAD>"
End Sub

Sub PrintTableHeader_AgentStats

  If displayPageHeader = 1 Then
  Response.Write "<table id='csqPageHeader'><tr>"
  Response.Write "<td id='csqPageHeaderLeft'>" & strPageHeader_AgentStats & "</td>"
  Response.Write "<td id='csqPageHeaderRight'>" 

	sOffset = +0 'The time offset from GMT at the server 
	cTime = i + sOffset 
	tDiff = (DateAdd("h",cTime,Now)) 
	Response.write FormatDateTime(tDiff,3)

  Response.Write "</td>"
  Response.Write "</tr></table>"
  End If
  IF holdPageLink = 1 Then
	  Response.Write "<div id='holdPage'>"
	  If Request.QueryString("PageHeld") = "YES" Then
	  Response.Write "<a href='" & serverURL & "default.asp'>(click here to unhold page)</a>"
	  Else
	  Response.Write "<a href='" & serverURL & "default.asp?Stats=CSQHeld&PageHeld=YES'>(click here to hold page)</a>"
	  End If
	  Response.Write "</div>"
  End If
  If LogoOn = 1 Then
  	Response.Write "<IMG BORDER='0' ALIGN='left' SRC='" & ServerURL & LogoFile & "'<br>"
  End If

  If Request.QueryString("PageHeld") = "YES" Then
  Response.Write "<CENTER><a href='" & serverURL & "default.asp'><FONT SIZE ='2' COLOR='red'>(click here to unhold page)</FONT></a></CENTER><BR>"
  Else
  Response.Write "<CENTER><a href='" & serverURL & "default.asp?Stats=AgentHeld&PageHeld=YES'><FONT SIZE ='2' COLOR='black'>(click here to hold page)</FONT></a></CENTER>"
  End If
  'Response.Write "<IMG BORDER='0' ALIGN='left' SRC='" & ServerURL & LogoFile & "'<br>"

  Response.Write "<TABLE class='csqWrapper' bgcolor=" & TextColor & ">"
  Response.Write "<tr>"
  Response.Write "<TD class='agentColumnHeader'>" & TableColumnHeader_AgentStats_Column1 & "</TD>"
  Response.Write "<TD class='agentColumnHeader'>" & TableColumnHeader_AgentStats_Column2 & "</TD>"
  Response.Write "<TD class='agentColumnHeader'>" & TableColumnHeader_AgentStats_Column3 & "</TD>"
  Response.Write "</tr>"

End Sub

Sub DisplayAgentStatistics
  Set objCN = Server.CreateObject("ADODB.Connection")
  If IPCCversion = 3 Then
    objCN.Open "Provider=SQLOLEDB; Data Source = " & DBsource & "; Initial Catalog = " & DBdatabase & "; User Id = " & DBuserID & "; Password = " & DBpass
  ElseIf IPCCversion = 4 Then
    objCN.Open "Provider=SQLOLEDB; Data Source = " & DBsource & "\CRSSQL; Initial Catalog = db_cra; Integrated Security=SSPI;" 
  ElseIf IPCCversion = 8 Then
    If PullAgentStatsFromSecondary = 1 Then
      objCN.Open "Dsn="& DSNSecondary &"; Host= " & DBsourceSecondary & "; Server= "& DBServerSecondary & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
    Else
      objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
    End if
  ElseIf IPCCversion = 9 Then
    If PullAgentStatsFromSecondary = 1 Then
      objCN.Open "Dsn="& DSNSecondary &"; Host= " & DBsourceSecondary & "; Server= "& DBServerSecondary & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
    Else
      objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
    End if
  ElseIf IPCCversion = 10 Then
    If PullAgentStatsFromSecondary = 1 Then
      objCN.Open "Dsn="& DSNSecondary &"; Host= " & DBsourceSecondary & "; Server= "& DBServerSecondary & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
    Else
      objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
    End if
  Else
      Response.Write "<TD><FONT SIZE ='16' COLOR='RED'>The database connection is not configured correctly.  Please update the IPCCversion variable in parameters.cfg.<br>IPCCversion is currently set to: " & IPCCversion & " <br>Acceptable values are 3, 4, 8, 9, or 10</FONT></TD>" 
  End If

  If UCCXTeamID1 <> "" Then
	teamsToTrack = " WHERE x.assignedTeamID =" & UCCXTeamID1 & " "
    Else
	Response.Write "<FONT SIZE ='50' color='red'>You have not set any teams to track.  Please set the UCCXTeamID1 variable in the parameters.cfg</FONT></TD>" 
	teamsToTrack = " WHERE x.assignedTeamID ='1'"
  End if
  If UCCXTeamID2 <> "" Then
	teamsToTrack = teamsToTrack & " OR x.assignedTeamID =" & UCCXTeamID2 & " "
  End if
  If UCCXTeamID3 <> "" Then
	teamsToTrack = teamsToTrack & " OR x.assignedTeamID =" & UCCXTeamID3 & " "
  End if
  If UCCXTeamID4 <> "" Then
	teamsToTrack = teamsToTrack & " OR x.assignedTeamID =" & UCCXTeamID4 & " "
  End if
  If UCCXTeamID5 <> "" Then
	teamsToTrack = teamsToTrack & " OR x.assignedTeamID =" & UCCXTeamID5 & " "
  End if

Response.Write teamsToTrack
  strSQL = "SELECT x.resourceName, t.eventType, x.assignedTeamID, x.datetime FROM (SELECT t1.resourceID, t1.resourceName, t1.assignedTeamID, MAX(t2.eventDateTime) AS datetime FROM Resource AS t1 INNER JOIN AgentStateDetail AS t2 ON t2.agentID = t1.resourceID GROUP BY t1.resourceID, t1.resourceName, t1.assignedTeamID ) AS x INNER JOIN AgentStateDetail AS t ON t.agentID = x.resourceID AND t.eventDateTime = x.datetime " & teamsToTrack & " ORDER BY x.resourceName"

  Set objRS = objCN.Execute(strSQL)

  While Not objRS.EOF
    If objRS("eventType") = 7 Then 
     strAgentStatus = "Logged Out"
     TableColor = TableColor_LoggedOut
     TextColor = TextColor_AgentStats_LoggedOut
    End If
    If objRS("eventType") = 6 Then 
     strAgentStatus = "Working"
     TableColor = TableColor_Working
     TextColor = TextColor_AgentStats_Working
    End If
    If objRS("eventType") = 5 Then 
     strAgentStatus = "Talking"
     TableColor = TableColor_Talking
     TextColor = TextColor_AgentStats_Talking
    End If
    If objRS("eventType") = 4 Then 
     strAgentStatus = "Reserved"
     TableColor = TableColor_Reserved
     TextColor = TextColor_AgentStats_Reserved
    End If
    If objRS("eventType") = 3 Then 
     strAgentStatus = "Ready"
     TableColor = TableColor_Ready
     TextColor = TextColor_AgentStats_Ready
    End If
    If objRS("eventType") = 2 Then 
     strAgentStatus = "Not Ready"
     TableColor = TableColor_NotReady
     TextColor = TextColor_AgentStats_NotReady
    End If
    If objRS("eventType") = 1 Then 
     strAgentStatus = "Logged In"
     TableColor = TableColor_LoggedIn
     TextColor = TextColor_AgentStats_LoggedIn
    End If
    Call CalculateStatusTime (objRS("datetime"))
    Call CheckAgentStatusBlinking
    'Response.Write objRS("resourceName")
    'Response.Write objRS("datetime")
    'Response.Write CurrentDateTime
    If intAgentStatsMaxDays = 0 Then
      Response.Write "<TR>"
      Response.Write "<TD BGCOLOR='" & TableColor & "'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>"  & objRS("resourceName") & "</FONT></TD>" 
      Response.Write "<TD BGCOLOR='" & TableColor & "' ALIGN='CENTER'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>" & strAgentStatus & "</FONT></TD>" 
      Response.Write "<TD BGCOLOR='" & TableColor & "' ALIGN='CENTER'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>" & strStatusDays & " days / " & strStatusHours & ":" & strStatusMinutes & ":" & strStatusSeconds & "</FONT></TD>"
      Response.Write "</TR>" & VbCrLf
    End If
    If intAgentStatsMaxDays = 1 And intStatusDays < intAgentStatsMaxDays And intStatusHours < intAgentStatsMaxHours Then
        Response.Write "<TR>"
        If AgentStatusBlink = 1 And strAgentStatus = "Not Ready" then
          Response.Write "<TD BGCOLOR='" & TableColor & "'><BLINK SPEED=1000><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>"  & objRS("resourceName") & "</FONT></BLINK></TD>" 
          Response.Write "<TD BGCOLOR='" & TableColor & "' ALIGN='CENTER'><BLINK SPEED=1000><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>" & strAgentStatus & "</FONT></BLINK></TD>" 
          Response.Write "<TD BGCOLOR='" & TableColor & "' ALIGN='CENTER'><BLINK SPEED=1000><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>" & strStatusHours & ":" & strStatusMinutes & ":" & strStatusSeconds & "</FONT></BLINK></TD>"
        Else
          Response.Write "<TD BGCOLOR='" & TableColor & "'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>"  & objRS("resourceName") & "</FONT></TD>" 
          Response.Write "<TD BGCOLOR='" & TableColor & "' ALIGN='CENTER'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>" & strAgentStatus & "</FONT></TD>" 
          Response.Write "<TD BGCOLOR='" & TableColor & "' ALIGN='CENTER'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>" & strStatusHours & ":" & strStatusMinutes & ":" & strStatusSeconds & "</FONT></TD>"
        End If
        Response.Write "</TR>" & VbCrLf
    End If
    If intAgentStatsMaxDays > 1 And intStatusDays < intAgentStatsMaxDays Then
        Response.Write "<TR>"
        Response.Write "<TD BGCOLOR='" & TableColor & "'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>"  & objRS("resourceName") & "</FONT></TD>" 
        Response.Write "<TD BGCOLOR='" & TableColor & "' ALIGN='CENTER'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>" & strAgentStatus & "</FONT></TD>" 
        Response.Write "<TD BGCOLOR='" & TableColor & "' ALIGN='CENTER'><FONT SIZE =' " & TextSize_AgentStats & " ' COLOR='" & TextColor & "'>" & strStatusDays & " days / " & strStatusHours & ":" & strStatusMinutes & ":" & strStatusSeconds & "</FONT></TD>"
        Response.Write "</TR>" & VbCrLf
    End If
   objRS.MoveNext
  Wend
  objRS.Close
  objCN.Close
  Set objCN = Nothing
  Set objRS = Nothing
End Sub

Sub PrintTableFooter_Agent
  Response.Write "</TABLE>"
End Sub

//********************************END AGENT MODULE**************************************//



//********************************START CSQ MODULE**************************************//

//**************************************************************************************//
//   Module:  	Display CSQ Stats														//
//   AUTHOR:  	Leo Mourits																//
//   PURPOSE: 	Displays CSQ Statistics													//
//**************************************************************************************//


Sub PrintPageHeader_CSQStats
  Response.Write "<HTML><BODY BGCOLOR='#FFFFFF'><HEAD><TITLE>" & strPageTitle & "</TITLE>"
  Response.Write "<STYLE><!--  @media screen  { blink { behavior:url(blink.htc);} } --></STYLE>"
  Response.Write "<link rel='shortcut icon' type='image/x-icon' href='" & ServerURL & "favicon.ico' />"
  Response.Write "<link type=text/css href=./style.css rel=stylesheet />"
  Response.Write "</HEAD>"
End Sub

Sub PrintTableHeader_CSQStats

End Sub

Sub DisplayCSQStatistics
  Set objCN = Server.CreateObject("ADODB.Connection")
  If IPCCversion = 3 Then
    objCN.Open "Provider=SQLOLEDB; Data Source = " & DBsource & "; Initial Catalog = " & DBdatabase & "; User Id = " & DBuserID & "; Password = " & DBpass
  ElseIf IPCCversion = 4 Then
    objCN.Open "Provider=SQLOLEDB; Data Source = " & DBsource & "\CRSSQL; Initial Catalog = db_cra; Integrated Security=SSPI;" 
  ElseIf IPCCversion = 8 Then
    objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
  ElseIf IPCCversion = 9 Then
    objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
  ElseIf IPCCversion = 10 Then
    objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
  Else
      Response.Write "<TD><FONT SIZE ='16' COLOR='RED'>The database connection is not configured correctly.  Please update the IPCCversion variable in parameters.cfg.<br>IPCCversion is currently set to: " & IPCCversion & " <br>Acceptable values are 3, 4, 8, 9, or 10</FONT></TD>" 
  End If


  If DisplaySpecificCSQ = 1 Then

  If not (UCCXCSQ1 = "") Then
    csqSpecificOrder = "(Case When CSQName = '" & UCCXCSQ1 & "' then 0 "
  End If
  If not (UCCXCSQ2 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ2 & "' then 1 "
  End If
  If not (UCCXCSQ3 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ3 & "' then 2 "
  End If
  If not (UCCXCSQ4 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ4 & "' then 3 "
  End If
  If not (UCCXCSQ5 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ5 & "' then 4 "
  End If
  If not (UCCXCSQ6 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ6 & "' then 5 "
  End If
  If not (UCCXCSQ7 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ7 & "' then 6 "
  End If
  If not (UCCXCSQ8 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ8 & "' then 7 "
  End If
  If not (UCCXCSQ9 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ9 & "' then 8 "
  End If
  If not (UCCXCSQ10 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ10 & "' then 9 "
  End If
  If not (UCCXCSQ11 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ11 & "' then 10 "
  End If
  If not (UCCXCSQ12 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ12 & "' then 11 "
  End If
  If not (UCCXCSQ13 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ13 & "' then 12 "
  End If
  If not (UCCXCSQ14 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ14 & "' then 13 "
  End If
  If not (UCCXCSQ15 = "") Then
    csqSpecificOrder = csqSpecificOrder & " When CSQName = '" & UCCXCSQ15 & "' then 14 "
  End If
  csqSpecificOrder = csqSpecificOrder & " End)"

  selectSQL  = "SELECT CSQName, loggedInAgents, availableAgents, callsWaiting, callsHandled, totalCalls, callsAbandoned, convoldestContact, convLongestWaitDuration, endDateTime, talkingagents, startdatetime FROM RtCSQsSummary "
  whereSQL   = "where (CSQName = '" & UCCXCSQ1 & "') or (CSQName = '" & UCCXCSQ2 & "') or (CSQName = '" & UCCXCSQ3 & "') or (CSQName = '" & UCCXCSQ4 & "') or (CSQName = '" & UCCXCSQ5 & "')  or (CSQName = '" & UCCXCSQ6 & "') or (CSQName = '" & UCCXCSQ7 & "') or (CSQName = '" & UCCXCSQ8 & "') or (CSQName = '" & UCCXCSQ9 & "') or (CSQName = '" & UCCXCSQ10 & "') or (CSQName = '" & UCCXCSQ11 & "') or (CSQName = '" & UCCXCSQ12 & "') or (CSQName = '" & UCCXCSQ13 & "') or (CSQName = '" & UCCXCSQ14 & "') or (CSQName = '" & UCCXCSQ15 & "') " 
  orderbySQL = "ORDER BY " & csqSpecificOrder
  strsql = selectSQL & whereSQL & orderbySQL

  Else
  strsql = "SELECT CSQName, loggedInAgents, availableAgents, callsWaiting, callsHandled, totalCalls, callsAbandoned, convoldestContact, convLongestWaitDuration, endDateTime, talkingagents, startdatetime FROM RtCSQsSummary ORDER BY CSQName"
  End If

  Set objRS = objCN.Execute(strSQL)

  If displayPageHeader = 1 Then
  Response.Write "<table id='csqPageHeader'><tr>"
  Response.Write "<td id='csqPageHeaderLeft'>stats began at " & objRS("startdatetime") & " EST</td>"
  Response.Write "<td id='csqPageHeaderRight'>" 

	sOffset = +0 'The time offset from GMT at the server 
	cTime = i + sOffset 
	tDiff = (DateAdd("h",cTime,Now)) 
	Response.write FormatDateTime(tDiff,3)

  Response.Write "</td>"
  Response.Write "</tr></table>"
  End If
  IF holdPageLink = 1 Then
	  Response.Write "<div id='holdPage'>"
	  If Request.QueryString("PageHeld") = "YES" Then
	  Response.Write "<a href='" & serverURL & "default.asp'>(click here to unhold page)</a>"
	  Else
	  Response.Write "<a href='" & serverURL & "default.asp?Stats=CSQHeld&PageHeld=YES'>(click here to hold page)</a>"
	  End If
	  Response.Write "</div>"
  End If
  If LogoOn = 1 Then
  	Response.Write "<IMG BORDER='0' ALIGN='left' SRC='" & ServerURL & LogoFile & "'<br>"
  End If


  While Not objRS.EOF
    If objRS("availableAgents") < intCSQStatsMinAgentsAvailable Then
      If objRS("callsWaiting") > intCSQStatsMaxQueuedCalls Then
        TextColor = TextColor_CSQStats_ArtNoAgentsAndCallsInQueue
        TableColor = TableColor_CSQStats_ArtNoAgentsAndCallsInQueue
      Else 
        TextColor = TextColor_CSQStats_AlertNoAgents
        TableColor = TableColor_CSQStats_AlertNoAgents
      End If
    Else
        TextColor = TextColor_CSQStats_StatusOkay 
        TableColor = TableColor_CSQStats_StatusOkay 
    End If

    If usePrettyNamesIfDefined = 1 Then
	    If objRS("CSQName") = UCCXCSQ1 Then
		prettyCSQname = UCCXCSQ1friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ2 Then
		prettyCSQname = UCCXCSQ2friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ3 Then
		prettyCSQname = UCCXCSQ3friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ4 Then
		prettyCSQname = UCCXCSQ4friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ5 Then
		prettyCSQname = UCCXCSQ5friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ6 Then
		prettyCSQname = UCCXCSQ6friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ7 Then
		prettyCSQname = UCCXCSQ7friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ8 Then
		prettyCSQname = UCCXCSQ8friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ9 Then
		prettyCSQname = UCCXCSQ9friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ10 Then
		prettyCSQname = UCCXCSQ10friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ11 Then
		prettyCSQname = UCCXCSQ11friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ12 Then
		prettyCSQname = UCCXCSQ12friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ13 Then
		prettyCSQname = UCCXCSQ13friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ14 Then
		prettyCSQname = UCCXCSQ14friendlyName
	    ElseIf  objRS("CSQName") = UCCXCSQ15 Then
		prettyCSQname = UCCXCSQ15friendlyName
	    Else
		prettyCSQname = objRS("CSQName")
	    End If
    Else
	prettyCSQname = objRS("CSQName")
    End If

    callsDequeued = 0
    callsDequeued = objRS("totalCalls") - objRS("callsHandled") - objRS("callsAbandoned") - objRS("callsWaiting")


If OnlyOneQueue = 1 Then

    Response.Write "<TABLE class='csqWrapper' bgcolor=" & TextColor & ">"
    Response.Write "<tr>"

    Response.Write "<td colspan='2' class='csqNameSingle'>" & prettyCSQname & "</td>"

      Response.Write "<td><table class='csqContainer' >"
    If DisplayCSQloggedInAgents = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column2 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("loggedInAgents") & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>" 

      Response.Write "</tr><tr>"

      Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQavailableAgents = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column3 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("availableAgents") & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>" 

      Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQtalkingAgents = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column4 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("talkingAgents") & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>" 

      Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQcallsWaiting = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column5 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("callsWaiting") & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>"

      Response.Write "</tr><tr>"

      Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQcallsHandled = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column6 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("callsHandled") & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>"

      Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQcallsDequeued = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column11 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & callsDequeued & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>"

      Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQlongestWaitCurrent = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column9 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("convoldestContact") & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>"

      Response.Write "</tr><tr>"

      Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQcallsAbandoned = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column8 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("callsAbandoned") & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>"

      Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQtotalCalls = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column7 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("totalCalls") & "</FONT></TD></tr>" 
    End If
      Response.Write "</table></td>"

     Response.Write "<td><table class='csqContainer'>"
    If DisplayCSQlongestWaitDuration = 1 Then
      Response.Write "<tr><TD class='csqColumnHeaderSingle'>" & TableColumnHeader_CSQStats_Column10 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnDataSingle' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("convLongestWaitDuration") & "</FONT></TD></TR>"
    End If
      Response.Write "</table></td>"

      Response.Write "</tr></table>" & VbCrLf

Else

    Response.Write "<TABLE class='csqWrapper' bgcolor=" & TextColor & ">"
    Response.Write "<tr><TD class='csqName' colspan='4'>" & prettyCSQname & "</TD></tr>"
    Response.Write "<tr>"

    If DisplayCSQloggedInAgents = 1 Then
      Response.Write "<td><table class='csqContainer' >"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column2 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("loggedInAgents") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayCSQavailableAgents = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column3 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("availableAgents") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayCSQtalkingAgents = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column4 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("talkingAgents") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayCSQcallsWaiting = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column5 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("callsWaiting") & "</FONT></TD></tr>" 
      Response.Write "</table></td>"
    End If
    If DisplayCSQcallsHandled = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column6 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("callsHandled") & "</FONT></TD></tr>" 
      Response.Write "</table></td>"
    End If
    If DisplayCSQcallsDequeued = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column11 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & callsDequeued & "</FONT></TD></tr>" 
      Response.Write "</table></td>"
    End If
    If DisplayCSQcallsAbandoned = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column8 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("callsAbandoned") & "</FONT></TD></tr>" 
      Response.Write "</table></td>"
    End If
    If DisplayCSQlongestWaitCurrent = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column9 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("convoldestContact") & "</FONT></TD></tr>" 
      Response.Write "</table></td>"
    End If
    If DisplayCSQlongestWaitDuration = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column10 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("convLongestWaitDuration") & "</FONT></TD></TR>"
      Response.Write "</table></td>"
    End If
    If DisplayCSQtotalCalls = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_CSQStats_Column7 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData' BGCOLOR='" & TableColor_CSQStats & "'>" & objRS("totalCalls") & "</FONT></TD></tr>" 
      Response.Write "</table></td>"
    End If
      Response.Write "</tr></table>" & VbCrLf


End If

    lastupdate = objRS("endDateTime")
    objRS.MoveNext
  Wend
  objRS.Close
  objCN.Close
  Set objCN = Nothing
  Set objRS = Nothing
End Sub

Sub PrintTableFooter_CSQ
  Response.Write "</TABLE>"
End Sub

//*********************************END CSQ MODULE***************************************//



//********************************START ICD MODULE**************************************//

//**************************************************************************************//
//   Module:  	Displays ICD Stats														//
//   AUTHOR:  	Jeremy Fielder															//
//   PURPOSE: 	Displays ICD Statistics													//
//**************************************************************************************//


Sub PrintPageHeader_ICDStats
  Response.Write "<HTML><BODY BGCOLOR='#FFFFFF'><HEAD><TITLE>" & strPageTitle & "</TITLE>"
  Response.Write "<STYLE><!--  @media screen  { blink { behavior:url(blink.htc);} } --></STYLE>"
  Response.Write "<link rel='shortcut icon' href='" & ServerURL & "favicon.ico' />"
  Response.Write "<link type=text/css href=./style.css rel=stylesheet />"
  Response.Write "</HEAD>"
End Sub

Sub PrintTableHeader_ICDStats

End Sub

Sub DisplayICDStatistics
  Set objCN = Server.CreateObject("ADODB.Connection")
  If IPCCversion = 3 Then
    objCN.Open "Provider=SQLOLEDB; Data Source = " & DBsource & "; Initial Catalog = " & DBdatabase & "; User Id = " & DBuserID & "; Password = " & DBpass
  ElseIf IPCCversion = 4 Then
    objCN.Open "Provider=SQLOLEDB; Data Source = " & DBsource & "\CRSSQL; Initial Catalog = db_cra; Integrated Security=SSPI;" 
  ElseIf IPCCversion = 8 Then
    objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
  ElseIf IPCCversion = 9 Then
    objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
  ElseIf IPCCversion = 10 Then
    objCN.Open "Dsn="& DSN &"; Host= " & DBsource & "; Server= "& DBServer & "; Service=1504; Protocol=onsoctcp; Database= " & DBdatabase & "; Uid= " & DBuserID & "; Pwd= " & DBpass
  Else
      Response.Write "<TD><FONT SIZE ='16' COLOR='RED'>The database connection is not configured correctly.  Please update the IPCCversion variable in parameters.cfg.<br>IPCCversion is currently set to: " & IPCCversion & " <br>Acceptable values are 3, 4, 8, 9, or 10</FONT></TD>" 
  End If
  strsql = "SELECT * FROM RtICDStatistics"
  Set objRS = objCN.Execute(strSQL)



  If displayPageHeader = 1 Then
  Response.Write "<table id='csqPageHeader'><tr>"
  Response.Write "<td id='csqPageHeaderLeft'>stats began at " & objRS("startdatetime") & " EST</td>"
  Response.Write "<td id='csqPageHeaderRight'>" 

	sOffset = +0 'The time offset from GMT at the server 
	cTime = i + sOffset 
	tDiff = (DateAdd("h",cTime,Now)) 
	Response.write FormatDateTime(tDiff,3)

  Response.Write "</td>"
  Response.Write "</tr></table>"
  End If
  IF holdPageLink = 1 Then
	  Response.Write "<div id='holdPage'>"
	  If Request.QueryString("PageHeld") = "YES" Then
	  Response.Write "<a href='" & serverURL & "default.asp'>(click here to unhold page)</a>"
	  Else
	  Response.Write "<a href='" & serverURL & "default.asp?Stats=ICDHeld&PageHeld=YES'>(click here to hold page)</a>"
	  End If
	  Response.Write "</div>"
  End If
  If LogoOn = 1 Then
  	Response.Write "<IMG BORDER='0' ALIGN='left' SRC='" & ServerURL & LogoFile & "'<br>"
  End If





  While Not objRS.EOF

        TextColor = TextColor_ICDStats
        TableColor = TableColor_ICDStats

    Response.Write "<TABLE class='csqWrapper' bgcolor=" & TextColor & ">"
    Response.Write "<tr><TD class='csqName' colspan='4'>" & prettyCSQname & "</TD></tr>"
    Response.Write "<tr>"

		
	If DisplayICDTotalCSQs = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column1 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("totalCSQs") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End IF
	If DisplayICDloggedInAgents = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column2 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("loggedInAgents") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayICDavailableAgents = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column3 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("availableAgents") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayICDcallsWaiting = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column4 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("callsWaiting") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayICDcallsHandled = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column5 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("callsHandled") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayICDtotalCalls = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column6 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("totalCalls") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayICDcallsAbandoned = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column7 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("callsAbandoned") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayICDlongestWaitCurrent = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column8 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("convoldestContact") & "</FONT></TD></tr>" 
      Response.Write "</table></td>" 
    End If
    If DisplayICDlongestWaitDuration = 1 Then
      Response.Write "<td><table class='csqContainer'>"
      Response.Write "<tr><TD class='csqColumnHeader'>" & TableColumnHeader_ICDStats_Column9 & " </TD></tr>"
      Response.Write "<tr><TD class='csqColumnData'>" & objRS("convLongestWaitDuration") & "</FONT></TD></tr>" 
      Response.Write "</table></td></tr>"
      Response.Write "</table>" & VbCrLf
    End If
    lastupdate = objRS("endDateTime")
    objRS.MoveNext
  Wend
  objRS.Close
  objCN.Close
  Set objCN = Nothing
  Set objRS = Nothing
End Sub

Sub PrintTableFooter_ICD

End Sub

//*********************************END ICD MODULE***************************************//



//*****************************START PAGE FOOTER MODULE*********************************//

//**************************************************************************************//
//   Module:  	Print Page Footer														//
//   AUTHOR:  	Leo Mourits																//
//   PURPOSE: 	Adds the update and refresh info to the page footer.					//
//**************************************************************************************//


Sub PrintPageFooter
  CurrentDateTime = CDate(Date() & " " & Time())
  If wallboardFooterCredit = 1 Then
    Response.Write "<P id='footer'>"
    Response.Write "UCGuru Wallboard v1.42"
    Response.Write "</P></BODY></HTML>"
  End If
End Sub


//******************************END PAGE FOOTER MODULE**********************************//



//***************************START STATUS BLINKING MODULE*******************************//

//**************************************************************************************//
//   Module:  	Status Blinking															//
//   AUTHOR:  	Leo Mourits																//
//   PURPOSE: 	Enables Blinking Text when user defined thresholds have been exceeded.	//
//**************************************************************************************//

Sub CheckAgentStatusBlinking
  If intAgentStatsMaxNotReady = 0 Or intAgentStatsMaxNotReady > 59 Then
    AgentStatusBlink = 0
  Else
    If intStatusMinutes >= intAgentStatsMaxNotReady Then
      AgentStatusBlink = 1
    Else
      AgentStatusBlink = 0
    End If
  End If
  If intStatusHours > 0 Then
    AgentStatusblink = 1
  End If
End Sub

//****************************END STATUS BLINKING MODULE********************************//



//***************************START CALC STATUS TIME MODULE******************************//

//**************************************************************************************//
//   Module:  	Calculate Status Time													//
//   AUTHOR:  	Leo Mourits																//
//   PURPOSE: 	Calculates the time an agent has been in the reported state.			//
//**************************************************************************************//


Sub CalculateStatusTime (eventDateTimeIn)
  ' The string returned in eventDateTime is a string of the form "MM/DD/YYYY HH:MM:SS [AM/PM]"
  ' The difference between current date/time and event date/time give the time that the agent is in the current status
  ' dateDiff calculates the difference between two date values and can return this in seconds, minutes, hours, et cetera
  strArray = split(eventDateTimeIn," ")
  EventHappenedDateTime = CDate(strArray(0) & " " & strArray(1) & " " & strArray(2))
  ' get the current date and time
  CurrentDateTime = CDate(Date() & " " & Time())
  ' calculate the difference between current date/time and date/time of the last event change
  intStatusSeconds = DateDiff("s",(EventHappenedDateTime - .20833),CurrentDateTime)
  ' we will need not only seconds, but also minutes, hours and days
  intStatusMinutes = Round((intStatusSeconds / 60),0)
  intStatusHours = Round((intStatusSeconds / 3600),0)
  intStatusDays = Round((intStatusSeconds / 86400),0)
  intStatusSeconds = intStatusSeconds - (intStatusMinutes * 60)
  ' because of the roun function used, we will need to fix some miscalculations because of rounding differences
  If intStatusSeconds < 0 Then intStatusSeconds = intStatusSeconds + (1 * 60) 
  intStatusMinutes = intStatusMinutes - (intStatusHours * 60)
  If intStatusMinutes < 0 Then intStatusMinutes = intStatusMinutes + (1 * 60) 
  intStatusHours = intStatusHours - (intStatusDays * 24)
  If intStatusSeconds > 30 Then intStatusMinutes = intStatusMinutes - 1
  If intStatusMinutes > 30 Then intStatusHours = intStatusHours - 1
  If intStatusHours < 0 Then intStatusHours = intStatushours + (1 * 24)
  If intStatusHours > 12 Then intStatusDays = intStatusDays - 1
  ' next we convert the integers to strings to be displayed on the page
  If intStatusMinutes < 10 Then
    If intStatusMinutes = 0 Then strStatusMinutes = "00"
    If intStatusMinutes = 1 Then strStatusMinutes = "01"
    If intStatusMinutes = 2 Then strStatusMinutes = "02"
    If intStatusMinutes = 3 Then strStatusMinutes = "03"
    If intStatusMinutes = 4 Then strStatusMinutes = "04"
    If intStatusMinutes = 5 Then strStatusMinutes = "05"
    If intStatusMinutes = 6 Then strStatusMinutes = "06"
    If intStatusMinutes = 7 Then strStatusMinutes = "07"
    If intStatusMinutes = 8 Then strStatusMinutes = "08"
    If intStatusMinutes = 9 Then strStatusMinutes = "09"
  Else
    strStatusMinutes = CStr(intStatusMinutes)
  End If
  If intStatusSeconds < 10 Then
    If intStatusSeconds = 0 Then strStatusSeconds = "00"
    If intStatusSeconds = 1 Then strStatusSeconds = "01"
    If intStatusSeconds = 2 Then strStatusSeconds = "02"
    If intStatusSeconds = 3 Then strStatusSeconds = "03"
    If intStatusSeconds = 4 Then strStatusSeconds = "04"
    If intStatusSeconds = 5 Then strStatusSeconds = "05"
    If intStatusSeconds = 6 Then strStatusSeconds = "06"
    If intStatusSeconds = 7 Then strStatusSeconds = "07"
    If intStatusSeconds = 8 Then strStatusSeconds = "08"
    If intStatusSeconds = 9 Then strStatusSeconds = "09"
  Else
    strStatusSeconds = CStr(intStatusSeconds)
  End If
  strStatusHours = CStr(intStatusHours)
  strStatusDays = CStr(intStatusDays)
End Sub

//****************************END CALC STATUS TIME MODULE*******************************//

'EOF

%>